<?php
/**
 * Created by PhpStorm.
 * User: angelos
 * Date: 29/01/18
 * Time: 12:17 PM
 */

namespace libs;

use DateTime;
use PDO;

//include_once("nucleo.php");

class connMedia
{

    public $v = false;
    private $pdo;
    private $host;
    private $user;
    private $pswd;
    private $base;
    private $query;
    private $type;
    private $begin;

    public function __construct($type = "my")
    {
        $this->type = $type;
        $this->pdo = null;
        $this->query = "";
        $this->begin = false;
    }

    public function debug($v = true)
    {
        $this->v = $v;
    }

    public function sql($query, $db = "")
    {
        $this->prepare($query, $db);
        $this->exec();
    }

    public function prepare($query, $db = '')
    {
        $this->query = $query;
        $this->base = $db;
    }

    public function exec($params = null)
    {
        $accion = str_word_count(trim($this->query), 1);

        switch ($accion[0]):
            case "INSERT":
                $accionNum = 1;
                break;
            case "UPDATE":
                $accionNum = 2;
                break;
            case "DELETE":
                $accionNum = 3;
                break;
            case "SELECT":
                $accionNum = 4;
                break;
            case "BEGIN":
                $accionNum = 5;
                break;
            case "COMMIT":
                $accionNum = 6;
                break;
            case "ROLLBACK":
                $accionNum = 7;
                break;
            default :
                $accionNum = 0;
                break;
        endswitch;

        $this->credenciales($this->base);

        try {
            $this->conectar();

        } catch (Exception $e) {
            throw new Exception("Error fatal: {$e->getMessage()}");
            exit();
        }

        try {

            $conn = $this->pdo->prepare($this->query);

            /*if (!is_null($params)) :
                foreach ($params as $param => $p):
                    $conn->bindValue($param, $p);
                endforeach;
            endif;*/

            $conn->execute();

            switch ($accionNum):
                case 1:
                    $ret = $this->pdo->lastInsertId();    //INSERT
                    break;
                case 2:
                case 3:
                    $ret = $conn->rowCount(); //UPDATE DELETE
                    break;
                case 5:
                case 6:
                case 7:
                    $ret = null;
                    break;
                default:
                    while (($resArray[] = $conn->fetch(PDO::FETCH_ASSOC)) || array_pop($resArray)) ;
                    $ret = $resArray;    //SELECT Y DEMAS
                    break;
            endswitch;
            /*else :
                var_dump($this->query);
                //throw new Exception("Error " . bitacora::agregarError($this->query, self::$link->errno . " - " . self::$link->error, "MySQL", $auth) . " en la consulta.");
                //echo ("Error " . $this->link->errno . " - " . $this->pdo->errorInfo(). " en la consulta.");*/
            //endif;

            //if (!$this->commit)
            //	$this->cerrar();

            if ($this->v):
                //nucleo::addConsola("Base de datos", $this->sql_debug($this->query, $params));
                echo "Base de datos", $this->sql_debug($this->query, $params);
            endif;

            return $ret;

        } catch (PDOException $e) {
            //TODO AQUI VA LA BITACORA
            echo 'Falló la conexión: ' . $e->getMessage();
        }

    }

    private function credenciales()
    {
        $this->host = "127.0.0.1";
        $this->user = "sisvalc_media";
        $this->pswd = "b+9PWw(LiWl%tJoji[";
        $this->base = "sisvalc_media";
    }

    private function conectar()
    {

        if (is_null($this->pdo)) {

            switch ($this->type) {
                case "my":
                case 'bitacora':
                    $this->pdo = new PDO("mysql:host={$this->host};dbname={$this->base};charset=utf8", $this->user, $this->pswd);
                    break;
            }

            $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->pdo->setAttribute(PDO::MYSQL_ATTR_INIT_COMMAND, "SET NAMES 'utf8'");

            if ($this->begin) {
                $this->pdo->beginTransaction();
                $this->begin = false;
            }
        }
    }

    public function sql_debug($sql_string, array $params = null)
    {
        if (!empty($params)) {
            $indexed = $params == array_values($params);
            foreach ($params as $k => $v) {
                if (is_object($v)) {
                    if ($v instanceof DateTime) $v = $v->format('Y-m-d H:i:s');
                    else continue;
                } elseif (is_string($v)) $v = "'$v'";
                elseif ($v === null) $v = 'NULL';
                elseif (is_array($v)) $v = implode(',', $v);

                if ($indexed) {
                    $sql_string = preg_replace('/\?/', $v, $sql_string, 1);
                } else {
                    if ($k[0] != ':') $k = ':' . $k; //add leading colon if it was left out
                    $sql_string = str_replace($k, $v, $sql_string);
                }
            }
        }
        return $sql_string;
    }

    public function cerrar()
    {
        $this->pdo = null;
    }

    public function begin()
    {
        $this->begin = true;
    }


    public function commit()
    {
        $this->pdo->commit();
        $this->begin = false;
    }

    public function rollback()
    {
        $this->pdo->rollBack();
        $this->begin = false;
    }

}
